const Service = require('node-windows').Service;
const path = require('path');
const readline = require('readline');
const fs = require('fs');

const serviceName = 'WE-LocalCloudService';
const serviceDescription = 'WE Filecloud local Service';
const serviceScript = path.join(__dirname, 'index.js');

const svc = new Service({
  name: serviceName,
  description: serviceDescription,
  script: serviceScript,
});

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout,
});

// Überprüfen, ob der Service bereits installiert ist
let isInstalled = svc.exists;

if (!fs.existsSync(path.join(__dirname, 'config.json'))) {
  const configTemplateFile = fs.readFileSync(path.join(__dirname, 'template_config.json'));
  fs.writeFileSync(path.join(__dirname, 'config.json'), configTemplateFile);
}

const configFile = fs.readFileSync(path.join(__dirname, 'config.json'));
const config = JSON.parse(configFile);

if (isInstalled) {
  svc.stop();
  console.log('Der Service ('+svc.id+') ist bereits installiert und wurde zur Konfiguration gestoppt.');
}

rl.question('- Host: ', (answer) => {
  if (answer.toLowerCase().trim() !== '') {
    config.host = answer;
    console.log('## Neuer Host: '+answer+'');
  }
  
  rl.question('- Nutzername: ', (answer) => {
    if (answer.toLowerCase().trim() !== '') {
      config.username = answer;
      console.log('## Neuer Nutzername: '+answer+'');
    }

    rl.question('- Passwort: ', (answer) => {
      if (answer.toLowerCase().trim() !== '') {
        config.password = answer;
        console.log('## Neues Passwort: '+answer+'');
      }
    
      rl.question('- Intervalldauer (Zeit zwischen Serverabfragen in Sekunden): ', (answer) => {
        if (answer.toLowerCase().trim() !== '') {
          config.interval = parseInt(answer, 10);
          console.log('## Neue Intervalldauer: '+answer+' Sekunde/n');
        }
      
        rl.question('- Nutzerverzeichnis (dort werden heruntergeladene Verzeichnis gespeichert. Platzhalter "{{USER}}" verwendet den aktuell angemeldeten Benutzer): ', (answer) => {
          if (answer.toLowerCase().trim() !== '') {
            config.osUserDirectory = answer;
            console.log('## Neues Nutzerverzeichnis: '+answer+'');
          }
        
          rl.question('- Nach wie vielen Tagen sollen Backups gelöscht werden? ', (answer) => {
            if (answer.toLowerCase().trim() !== '') {
              config.intervalDeleteBackups = parseInt(answer, 10);
              console.log('## Neuer Backupintervall: '+answer+' Tage/e');
            }
          
            console.log('---------------------------------------------------------');
            console.log('Host: '+config.host);
            console.log('Nutzername: '+config.username);
            console.log('Passwort: '+config.password);
            console.log('Intervalldauer: '+config.interval);
            console.log('Nutzerverzeichnis: '+config.osUserDirectory);
            console.log('Backupintervall: '+config.intervalDeleteBackups);
            console.log('---------------------------------------------------------');
            
            rl.question('Eingaben speichern? (J/N)', (answer) => {
              if (answer.toLowerCase().trim() === 'j') {
                fs.writeFileSync(path.join(__dirname, 'config.json'), JSON.stringify(config, null, 2), 'utf8');
                // Ausgabeverzeichnis anlegen
                if (!fs.existsSync(config.osUserDirectory)) {
                  fs.mkdirSync(config.osUserDirectory, { recursive: true });
                }
              }
              
              isInstalled = svc.exists;
              if (isInstalled) {
                rl.question('Service starten? (J/N)', (answer) => {
                  if (answer.toLowerCase().trim() === 'j') {
                    svc.restart();
                  }
                  rl.close();
                });
              } else {
                rl.close();
              }
            });
          });
          rl.write(String(config.intervalDeleteBackups));
        });
        rl.write(config.osUserDirectory);
      });
      rl.write(String(config.interval));
    });
    rl.write(config.password);
  });
  rl.write(config.username);
});
rl.write(config.host);


/* const path = require('path');

// console.log(path.join(__dirname, 'index.js'));

var Service = require('node-windows').Service;
var svc = new Service({
 name:'WE-LocalCloudService',
 description: 'WE Filecloud local Service',
 script: path.join(__dirname, 'index.js'),
});

svc.on('install',function(){
 svc.start();
});

svc.install(); */