const fs = require('fs');
const axios = require('axios');
const os = require('os');
const path = require('path');
//const zlib = require('zlib');
const AdmZip = require('adm-zip');
const archiver = require('archiver');
const FormData = require('form-data');

// config auslesen
const configFile = fs.readFileSync(path.join(__dirname, 'config.json'));
const config = JSON.parse(configFile);

// backup-Verzeichnis erstellen
if (!fs.existsSync(path.join(__dirname, 'backup'))) {
  fs.mkdirSync(path.join(__dirname, 'backup'), { recursive: true });
}

// Aktueller Status
let aktuelleStatusmeldung = '';
let neuStatusmeldung = '';

// Benutzerverzeichnis, in das das geladene Verzeichnis geladen werden soll
// const rootDirectory = path.join(os.homedir(), config.osUserDirectory);
const rootDirectory = config.osUserDirectory.split('{{USER}}').join(os.userInfo().username);

async function tryLogin() {
    config.key = '';
    let ausgabe = false;
    try {
      const body = new FormData();
      body.append('nn', config.username);
      body.append('pw', config.password);
      body.append('type', 'localService');
  
      const response = await axios.post(config.host + '/_api/vLogin/?doLogin', body, {
        headers: body.getHeaders(),
      });
  
      const res = response.data;
      if (!res.data) {
        console.error('[' + res.status + '] Verbindung zum Server fehlgeschlagen!');
      } else {
        if (res.status === 'success') {
          console.log('Login erfolgreich!');
          config.key = res.data.$_USER.code;
          ausgabe = true;
        } else {
          console.error('[' + res.status + '] Login fehlgeschlagen!');
        }
      }
  
      const saveData = JSON.stringify(config);
      fs.writeFileSync(path.join(__dirname, 'config.json'), saveData);
    } catch (error) {
      console.log(error);
    }
  
    return ausgabe;
}

async function tryGetSyncStatus() {
    let ausgabe = false;
    try {
      const body = new FormData();
      body.append('code', config.key);
  
      const response = await axios.post(config.host + '/_api/001-001/?001&getSyncStatus', body, {
        headers: body.getHeaders(),
      });
  
      const res = response.data;
      if (!res.data) {
        console.error('[' + res.status + '] Verbindung zum Server fehlgeschlagen!');
      } else {
        if (res.status === 'success') {
          if (res.data.sync.nameVerz) {
            config.directoryName = res.data.sync.nameVerz;
            config.directoryId = res.data.sync.idVerz;
            config.userId = res.data.user.id;
          }
          ausgabe = res.data.sync;
        }
      }
  
      const saveData = JSON.stringify(config);
      fs.writeFileSync(path.join(__dirname, 'config.json'), saveData);
    } catch (error) {
      console.log(error);
    }
    return ausgabe;
}

async function trySetSyncStatus({ status, statusInfo }) {
    let ausgabe = false;
    try {
      const body = new FormData();
      body.append('code', config.key);
      body.append('idVerz', config.directoryId);
      body.append('idUser', config.userId);
      body.append('status', status);
      body.append('statusInfo', statusInfo);
  
      const response = await axios.post(config.host + '/_api/001-001/?001&setLocalSync', body, {
        headers: body.getHeaders(),
      });
      
      if (response.status === 200) {
        const res = response.data;
        if (res.status === 'success') {
          ausgabe = true;
        } else {
          console.error('Verbindung zum Server fehlgeschlagen!', res);
        }
      }
    } catch (error) {
      console.log(error);
    }
    return ausgabe;
}
  

function deleteFolderRecursive(folderPath) {
    if (fs.existsSync(folderPath)) {
      fs.readdirSync(folderPath).forEach((file) => {
        const curPath = path.join(folderPath, file);
        if (fs.lstatSync(curPath).isDirectory()) {
          deleteFolderRecursive(curPath);
        } else {
          fs.unlinkSync(curPath);
        }
      });
      fs.rmdirSync(folderPath);
    }
}

function deleteDirectory(directoryPath) {
    // Überprüfe, ob das Verzeichnis existiert
    if (fs.existsSync(directoryPath)) {
        try {
          // Lösche das Verzeichnis und alle Inhalte rekursiv
          deleteFolderRecursive(directoryPath);
          console.log('Verzeichnis und alle Inhalte erfolgreich gelöscht:', directoryPath);
        } catch (err) {
          console.error('Fehler beim Löschen des Verzeichnisses und seiner Inhalte:', err);
        }
    }
}

function extractZipAndPackToDirectory(zipFilePath, outputDirectory) {
    return new Promise(async (resolve, reject) => {
        // Erstelle das Ausgabeverzeichnis, wenn es nicht existiert
        if (!fs.existsSync(outputDirectory)) {
            fs.mkdirSync(outputDirectory, { recursive: true });
        }
    
        // Entpacke die Zip-Datei
        try {
            const zip = new AdmZip(zipFilePath);
            zip.extractAllTo(outputDirectory, true);
            console.log('Zip-Datei wurde erfolgreich entpackt und in ein Verzeichnis gepackt:', outputDirectory);
            resolve();
        } catch (err) {
            console.error('Fehler beim Enpacken des Verzeichnisses: ', err);
            reject();
        }
    });
}

async function unzipSubdirectories(documentsPath) {
    return new Promise(async (resolve) => {
        const zipdateien = fs.readdirSync(documentsPath, { withFileTypes: true })
          .filter(entry => entry.name.endsWith('.zip'))
          .map(entry => path.join(documentsPath, entry.name));
      
        const promises = zipdateien.map(async (zip) => {
            await extractZipAndPackToDirectory(zip, zip.substring(0, zip.length - 4));
            fs.unlinkSync(zip);
        });
      
        // Auf die Beendigung aller asynchronen Vorgänge warten
        await Promise.all(promises);
        resolve();
    });
}

async function zipSubdirectories(documentsPath) {
    return new Promise(async (resolve) => {
        if (fs.existsSync(documentsPath)) {
            const unterverzeichnisse = fs.readdirSync(documentsPath, { withFileTypes: true })
            .filter(entry => entry.isDirectory())
            .map(entry => path.join(documentsPath, entry.name));
        
            const promises = unterverzeichnisse.map(async (subdir) => {
            await zipDirectory(subdir, subdir + '.zip', false);
            deleteFolderRecursive(subdir);
            });
        
            // Auf die Beendigung aller asynchronen Vorgänge warten
            await Promise.all(promises);
        }
        resolve();
    });
}

function zipDirectory(documentsPath, outputZipPath, boolOnlyFiles) {
    return new Promise(async (resolve, reject) => {
        // Überprüfe, ob das Unterverzeichnis existiert
        if (fs.existsSync(documentsPath)) {
            const output = fs.createWriteStream(outputZipPath);
            const archive = archiver('zip', { zlib: { level: 9 } });
            output.on('close', () => {
                console.log('Unterverzeichnis wurde erfolgreich in ein ZIP-Archiv umgewandelt:', outputZipPath);
                resolve();
            });
            /*output.on('end', () => {
                console.log('Datenstrom wurde geschlossen.');
            });*/
            archive.on('warning', (err) => {
                if (err.code === 'ENOENT') {
                    console.warn('Archivierungswarnung:', err);
                } else {
                    reject(err);
                }
            });
            archive.on('error', (err) => {
                reject(err);
            });
            archive.pipe(output);

            if (boolOnlyFiles) {
                // Bestimmte Dateien hinzufügen:
                const files = fs.readdirSync(documentsPath);
                for (const file of files) {
                    const filePath = path.join(documentsPath, file);
                    const stats = fs.statSync(filePath);
                    if (stats.isFile()) {
                        archive.file(filePath, { name: file });
                    }
                }
            } else {
                // Ganzes Verzeichnis hinzufügen:
                archive.directory(documentsPath, true);
            }

            archive.finalize();
        } else {
            console.log('Das Unterverzeichnis existiert nicht:', documentsPath);
            reject(new Error('Das Unterverzeichnis existiert nicht'));
        }
  });
}

let isUploading = false;
/*async function tryUploadVerz(idVerz) {
    isUploading = true;
    let ausgabe = false;
    const date = new Date();
    const zipName = idVerz + '-' + date.getTime() + '.zip';
    const zip = path.join(path.join(__dirname, 'backup'), 'zip-upload-' + zipName);
    if (fs.existsSync(path.join(rootDirectory, config.directoryName))) {
      if (config.zipSubdirectories) {
        await zipSubdirectories(path.join(rootDirectory, config.directoryName));
      }
      let boolOnlyFiles = false;
      if (config.zipSubdirectories) {
        boolOnlyFiles = true;
      }
      await zipDirectory(
        path.join(rootDirectory, config.directoryName),
        zip,
        boolOnlyFiles
      );
      if (fs.existsSync(zip)) {
        try {
          const stats = await fs.promises.stat(zip);
          const fileSizeInBytes = stats.size;
          const fileSizeInMB = fileSizeInBytes / (1024 * 1024); // Umrechnung in MB
          // Chunksize definieren (z.B. 32 MB)
          const chunkSize = 32 * 1024 * 1024; // 32 MB in Bytes
          const totalChunks = Math.ceil(fileSizeInBytes / chunkSize);

          const body = new FormData();
          body.append('code', config.key);
          body.append('idVerz', idVerz);

          // Chunks nacheinander senden
          let start = 0;
          for (let i = 0; i < totalChunks; i++) {
            const end = Math.min(start + chunkSize - 1, fileSizeInBytes - 1);
            const chunk = fs.createReadStream(zip, { start, end });

            // Header für den HTTP_CONTENT_RANGE-Header vorbereiten
            const contentRange = `bytes ${start}-${end}/${fileSizeInBytes}`;
            console.log(contentRange);

            // Fügen Sie den Chunk zum FormData-Objekt hinzu
            const formData = new FormData();
            formData.append('code', config.key);
            formData.append('idVerz', idVerz);
            formData.append('zip', chunk, { filename: 'zip-upload-' + zipName });

            // Senden Sie den Chunk
            const response = await axios.post(config.host + '/_api/001-001/?001&uploadVerz', formData, {
              headers: {
                ...formData.getHeaders(),
                'Content-Range': contentRange,
              },
            });

            console.log(response.data);

            // Aktualisieren Sie den Anfang für den nächsten Chunk
            start = end + 1;
          }

          // Behandle den letzten Chunk, um sicherzustellen, dass er die verbleibende Größe abdeckt
          if (start < fileSizeInBytes) {
            console.log('LETZTER CHUNK');
            const lastChunk = fs.createReadStream(zip, { start, end: fileSizeInBytes - 1 });
            const lastContentRange = `bytes ${start}-${fileSizeInBytes - 1}/${fileSizeInBytes}`;
            console.log(lastContentRange);
            
            const lastFormData = new FormData();
            lastFormData.append('code', config.key);
            lastFormData.append('idVerz', idVerz);
            lastFormData.append('zip', lastChunk, { filename: 'zip-upload-' + zipName });

            const lastResponse = await axios.post(config.host + '/_api/001-001/?001&uploadVerz', lastFormData, {
              headers: {
                ...lastFormData.getHeaders(),
                'Content-Range': lastContentRange,
              },
            });

            console.log(lastResponse.data);
          }

          isUploading = false;
          ausgabe = true;
          // deleteDirectory(path.join(rootDirectory, config.directoryName));
          return ausgabe;
        } catch (error) {
          isUploading = false;
          console.log(error);
          return ausgabe;
        }
      } else {
        return ausgabe;
      }
    } else {
      return ausgabe;
    }
} */

async function tryUploadVerz(idVerz) {
    isUploading = true;
    let ausgabe = {
      success: false,
      info: '',
    };
    const date = new Date();
    const zipName = idVerz + '-' + date.getTime() + '.zip';
    const zip = path.join(path.join(__dirname, 'backup'), 'zip-upload-' + zipName);
    if (fs.existsSync(path.join(rootDirectory, config.directoryName))) {
      if (config.zipSubdirectories) {
        await zipSubdirectories(path.join(rootDirectory, config.directoryName));
      }
      let boolOnlyFiles = false;
      if (config.zipSubdirectories) {
        boolOnlyFiles = true;
      }
      await zipDirectory(
        path.join(rootDirectory, config.directoryName),
        zip,
        boolOnlyFiles
      );
      if (fs.existsSync(zip)) {
        try {
          const body = new FormData();
          body.append('code', config.key);
          body.append('idVerz', idVerz);
          const zipFileData = fs.createReadStream(zip);
          body.append('zip', zipFileData, 'zip-upload-' + zipName);
          
          const stats = await fs.promises.stat(zip);
          const fileSizeInBytes = stats.size;
          const fileSizeInMB = fileSizeInBytes / (1024 * 1024); // Umrechnung in MB
        
          const response = await axios.post(config.host + '/_api/001-001/?001&uploadVerz', body, {
              headers: body.getHeaders(),
          });

          const res = response.data;
          if (!response.status === 200) {
              console.error('Verbindung zum Server fehlgeschlagen!', res);
          } else {
              if (res.status === 'success') {
              ausgabe = {
                success: true,
                info: '',
                fileSize: fileSizeInMB,
                res,
              };
              deleteDirectory(path.join(rootDirectory, config.directoryName));
              } else {
                console.log(res);
                console.error('[' + res.status + '] Verbindung zum Server fehlgeschlagen!');
              }
          }
          isUploading = false;
        } catch (error) {
          isUploading = false;
          console.log(error);
        }
      }
    }
    return ausgabe;
}

function deleteBackups() {
  const backupsPath = path.join(__dirname, 'backup');
  return new Promise(async (resolve) => {
    const zipdateien = fs.readdirSync(backupsPath, { withFileTypes: true })
      .filter(entry => entry.name.endsWith('.zip'))
      .map(entry => path.join(backupsPath, entry.name));
    
    let count = 0;
    const promises = zipdateien.map(async (zip) => {
      const zip_r = zip.split('-');
      const timestamp = parseInt(zip_r.pop().split('.zip').join(''), 10);
      if (timestamp) {
        const dateNow = new Date();
        const tageVergangen = (dateNow.getTime() - timestamp) / 1000 / 60 / 60 / 24;
        if (
          tageVergangen >= parseInt(config.intervalDeleteBackups, 10)
        ) {
          fs.unlinkSync(zip);
          count++;
        }
      }
    });

    if (count > 0 && count === 1) {
      console.log(count+' Backup, das älter als '+config.intervalDeleteBackups+' Tag/e ist, wurde gelöscht.');
    } else {
      console.log(count+' Backups, die älter als '+config.intervalDeleteBackups+' Tag/e sind, wurden gelöscht.');
    }
  
    // Auf die Beendigung aller asynchronen Vorgänge warten
    await Promise.all(promises);
    resolve();
  });
}

async function tryDownloadVerz(idVerz) {
  let ausgabe = false;
  const date = new Date();
  const zipName = idVerz+'-'+date.getTime()+'.zip';
  const speicherpfad = path.join(path.join(__dirname, 'backup'), 'zip-download-'+zipName);
  const data = new FormData();
  data.append('code', config.key);
  data.append('idVerz', idVerz);
  await axios({
    method: 'post',
    url: config.host+'/_api/001-001/?001&downloadVerz',
    data,
    responseType: 'stream',
  })
  .then((response) => {
    const writeStream = fs.createWriteStream(speicherpfad);
    response.data.pipe(writeStream);
    writeStream.on('finish', async () => {
        deleteDirectory(path.join(rootDirectory, config.directoryName));
        if (fs.existsSync(speicherpfad)) {
            try {
              // Heruntergeladene Zip entpacken:
              await extractZipAndPackToDirectory(
                speicherpfad,
                path.join(rootDirectory, config.directoryName),
              );
              // Zip-Dateien im entpackten Verzeichnis entzippen:
              if (config.zipSubdirectories) {
                await unzipSubdirectories(path.join(rootDirectory, config.directoryName));
              }
              // Heruntergeladene Zip löschen:
              fs.unlinkSync(speicherpfad);
            } catch (err) {
                console.log('Fehler beim Enpacken: ', err);
            }
        }
    });
    ausgabe = true;
  })
  .catch((error) => {
    console.error('Fehler: ', error);
  });
  return ausgabe;
}

function showStatusmeldung(text) {
  if (text !== aktuelleStatusmeldung) {
      aktuelleStatusmeldung = text;
      console.log(text);
  }
}

async function run() {
    console.log('Starte Dienst...');
    // config.key = '';
    const interval = setInterval(async () => {
      if (config.key === '') {
        await tryLogin();
      } else {
        // Wenn bereits eingeloggt, frage DB ab
        let syncStatus = false;
        if (!(syncStatus = await tryGetSyncStatus())) {
          config.key = '';
          showStatusmeldung('Fehler...')
        } else {
          if (isUploading) {
            showStatusmeldung('Lade hoch...');
          } else if (syncStatus.idVerz) {
            // Wenn ein Verzeichnis mit dem User verknüpft wurde,
            // Lies den Status aus
            showStatusmeldung('- Verzeichnis ID '+syncStatus.idVerz+' Status: '+syncStatus.status);
            if (syncStatus.status === 'sync') {
              // Synchronisierung neu eingestellt. Lade Verzeichnis herunter
              let http = false;
              if (!(http = await tryDownloadVerz(syncStatus.idVerz))) {
                console.log('Fehler beim Herunterladen des Verzeichnisses');
              } else {
                console.log('Verzeichnis heruntergeladen');
              }
              deleteBackups();
            } else if (syncStatus.status === 'forceUpload') {
              const res = await tryUploadVerz(syncStatus.idVerz);
              if (!(res.success)) {
                await trySetSyncStatus({ status: 'errorUpload-maxFileSize', statusInfo: JSON.stringify(res) });
                console.log('Fehler beim Hochladen des Verzeichnisses.');
              }
              deleteBackups();
            }
          } else {
            if (config.directoryName !== '') {
              deleteDirectory(path.join(rootDirectory, config.directoryName));
            }
            showStatusmeldung('- Kein zu synchronisierendes Verzeichnis gefunden.');
          }
        }
      }
      // clearInterval(interval);
    }, config.interval * 1000);
}

async function test() {
    const myPath = 'C:\\Users\\mail\\OneDrive\\Desktop\\Fabian Kaltenbach';
    /* await zipSubdirectories(myPath);
    let boolOnlyFiles = false;
    if (config.zipSubdirectories) {
      boolOnlyFiles = true;
    }
    await zipDirectory(
      myPath,
      myPath+'.zip',
      boolOnlyFiles,
    ); */
    if (config.zipSubdirectories) {
      await unzipSubdirectories(myPath);
    }
    console.log('fertig');
}

// test();

run();